% File Datacond - data conditioning of reactor data.
% The time scale is adjusted from seconds to sampling
% intervals (20 seconds). The variables are renamed as
% stored in the matrix var.
% vars(:,1) = time
% vars(:,2) = Fin, the reactor feed
% vars(:,3) = Fcw, the cooling water flow
% vars(:,4) = Conv, the reaction conversion
% vars(:,5) = Temp, the reactor temperature
clear all
clc
%
% load the data generated by CLdatgen.mdl
% data is stored every 20 sec, this is also the execution
% frequency of the PI controllers
%
load Rxdata;
vars = vars';
time = vars(:,1)/20;
Fin  = vars(:,2);
Fcw  = vars(:,3);
Conv = vars(:,4);
Temp = vars(:,5);
%
subplot(2,1,1);
plot(time, Fin);
xlabel('time (sampling intervals)');
ylabel('Fin(m^{3}s^{-1})')
grid on
%
subplot(2,1,2);
plot(time, Fcw);
xlabel('time (sampling intervals)');
ylabel('Fw(kgs^{-1})')
grid on
pause
%
subplot(2,1,1);
plot(time, Conv);
xlabel('time (sampling intervals)');
ylabel('Conversion')
grid on
%
subplot(2,1,2);
plot(time, Temp);
xlabel('time (sampling intervals)');
ylabel('Temperature, K')
grid on
pause
clc
%
