% File MISO_ID1.m, used for multi input single output
% parametric model identification
clear all;
echo on ;
clc;
%
% Identification of stepweights for non-integrating MISO 
% systems. MISO.MAT contains the output measurements and
% the columns for the different inputs.
% The following steps will be performed for each output-
% input combination:
%    1. Plot the output and input
%    2. Remove the trends
%    3. Calculate the cross correlation
%    4. Calculate the impulse weights and step response
%

load miso;
pause;
clc;

z = [TI3010-35.0 FC2100-150.0 FIC1010-100.0 TI1425-200.0];
[m,n] = size(z);
for i = 2:n
   z2 = [z(:,1) z(:,i)];
   idplot(z2);
   pause;
   clc;
   [ir,cf,cl] = cra(z2,30,10,1);
   stepr = cumsum(ir);
   pause,  % press a key for plot
   clf reset;
   plot(stepr); 
   title(sprintf('step-response model %d',i));
   xlabel('time(samples)'), pause
   clc;
end

%
% Use for identification of a first order OE model structure:
% y(t) = B(z)/F(z)*u1(t-nk) ... + e(t)
%
% use for B(z) = b1 - b2*z^(-1)
%         F(z) = 1  - a1*z^(-1)

pause;

nb = [1 1 1];
nf = [1 1 1];
nk = [10 6 2]; % as determined from the impulse and stepweights
nn = [nb nf nk];

% Estimate the model coefficients and calculate the residuals

th = oe(z,nn);
[e,r] = resid(z,th), pause;
plot(e), 
title('Residuals'),
pause;
clc;

% In order to verify the accuracy of the model, simulate the
% response and compare it to the measured output

out = z(:,1);
for i = 1:n-1
   in(:,i) = z(:,i+1) ;
end
yh = idsim(in, th); 
pause ;

plot([yh out]);
legend('measured output','simulated output',0);
xlabel('time(samples)') ; 
ylabel('y,ypred');
pause ;

% Calculate the step responses

input = zeros(60,n-1);
legend('off');

for i = 1:n-1
   input(:,i) = ones(60,1);
   stepr = idsim(input, th);
   plot (stepr);
   mstepr(:,i)  = stepr;
   input = zeros(60,n-1);
   title(sprintf('step-response model %d',i));
   xlabel ('time(samples)');
   pause;
end
save c:\matlabR13\work\misowts1.dat mstepr -ascii ;

% end miso_id1.m