% File MISO_ID2.m, used for multi input, single output
% non-parametric model identification
load miso
%
%  analysis of a non-integrating (stable) process
%  Write the process variables as deviation variables
%
u = [FC2100-150.0 FIC1010-100.0 TI1425-200.0];
y = TI3010-35.0;
%
%  Check the cross correlations
%
[ir,cf,cl] = cra([y u(:,1)]);
pause  % Press ENTER to continue
[ir,cf,cl] = cra([y u(:,2)]);
pause  % Press ENTER to continue
[ir,cf,cl] = cra([y u(:,3)]);
pause  % Press ENTER to continue
%
%  Put the input and output data in such a form that they can
%  be used to determine the impulse weights of the model.
%  Use 60 impulse weights
%
n = 60;
[ureg,yreg] = wrtreg(u,y,n);
%
%  Determine the impulse response coefficients using mlr.
%  No penalties on theta and delt theta are used in mlr.
%  Specify plotopt = 2, which will generate a plot of the
%  predicted output and actual output, and a plot of
%  the residual or modelling error
%
ninput  = 3;
plotopt = 2;
[theta,yres] = mlr(ureg,yreg,ninput,plotopt);
pause  % Press ENTER to continue
%
%  Check the autocorrelation of the residuals
%
[ir,cf,cl] = cra([yres yres]);
pause  % Press ENTER to continue
%
%  Convert the impulse model to a stepweight model
%  Sampling time delt = 1 minute was used
%  Specify number of outputs (nout = 1)
%
nout = 1;
delt = 1;
model = imp2step(delt,nout,theta);
%
save c:\matlabR13\work\misowts2.dat model -ascii;
%
%  Plot the step weights of the model
%
plotstep(model)
echo off
%
%load miso
%
%  analysis of an integrating (unstable) process
%  Write the process variables as deviation variables
%
%u = [FC2100-150.0 FIC1010-100.0 TI1425-200.0];
y = LI1483 - 70.0;
%
%   Set up the differences for model id
%
[mrow,ncol] = size(LI1483);
%dy(1,1) = 0;
%for i=2:mrow
%   dy(i,1) = y(i,1) - y(i-1,1);
%end
%
for j=1:3
   du(1,j) = 0.0;
end
for i=2:mrow
   for j=1:3
      du(i,j) = u(i,j) - u(i-1,j);
   end
end

%
%  Put the input and output data in such a form that they can
%  be used to determine the impulse weights of the model.
%  Use 60 impulse weights
%
n = 60;

[ureg,yreg] = wrtreg(du,y,n);
%
%  Determine the impulse response coefficients using mlr.
%  No penalties on theta and delt theta are used in mlr.
%  Specify plotopt = 2, which will generate a plot of the
%  predicted output and actual output, and a plot of
%  the residual or modelling error
%
ninput  = 3;
plotopt = 2;
[theta,yres] = mlr(ureg,yreg,ninput,plotopt);
pause  % Press ENTER to continue
%
%  Convert the impulse model to a stepweight model
%  Sampling time delt = 1 minute was used
%  Specify number of outputs (nout = 1)
%
nout = 1;
delt = 1;
model = imp2step(delt,nout,theta);
%
save c:\matlabR13\work\misowts3.dat model -ascii;
%
%  Plot the step weights of the model
%
plotstep(model)
echo off