% File Rxnmpi - Reactor non-parametric model identification
% This file assumes that you have run CLdatagen or
% OLdatagen to generate data for a closed loop or
% open loop process. Then run Datacond to condition
% the data.
%
% mean center the measurements
%
clc
mnFin  = mean(Fin);
mnFcw  = mean(Fcw);
mnConv = mean(Conv);
mnTemp = mean(Temp);
Fin    = Fin - mnFin;
Fcw    = Fcw - mnFcw;
Conv   = Conv - mnConv;
Temp   = Temp - mnTemp;
%
% determine 60 stepweights, first the conversion
% model, then the temperature model
%
n = 40;
[ureg, yreg] = wrtreg([Fin Fcw], Conv ,n);
ninput = 2; plotopt = 2;
[theta1, yres1] = mlr(ureg, yreg, ninput, plotopt);
%
[ureg, yreg] = wrtreg([Fin Fcw], Temp ,n);
ninput = 2; plotopt = 2;
[theta2, yres2] = mlr(ureg, yreg, ninput, plotopt);
%
% combine the models and plot the stepweights
% delt = 1 sampling interval (= 20 sec)
%
nout = 2; delt = 1;
model = imp2step(delt, nout, theta1, theta2);
plotstep(model)