%
% Static Relative Gain Array calculation
% Wood & Berry column
%
clear all;
echo off;
clc
K11 = 12.8;
K12 = -18.9;
K21 = 6.6;
K22 = -19.4;
RGA11 = abs(1/(1-K12*K21/(K11*K22)))
%
% Dynamic Relative Gain Array calculation
% Calculate 1000 points in the graph
%
for I = 1:1000
    a=3*I/1000-2;,
    w=10^(a);,        % from 10^(-2) to 10^(1)
    s=i*w;,
%
% Process is the Wood&Berry column
%
    g11=12.8*exp(-s)/(16.7*s+1);,
    g12=-18.9*exp(-3*s)/(21*s+1);,
    g21=6.6*exp(-7*s)/(10.9*s+1);,
    g22=-19.4*exp(-3*s)/(14.4*s+1);,
    W(I) = w;        % X-axis values
% lambda 11 values:
    lambda(I) = abs(1/(1-g12*g21/(g11*g22)));
end
semilogx(W,lambda)     % draw the graph
xlabel('frequency, rad/min');
ylabel('lambda 11');
title('DRGA Wood & Berry column');