% DAT2STEP converts MCPC stepweight files to MATLAB files in MPC format
%
%          Usage: model = dat2step(filename1, filename2, ni, no, system, delt)
%
%         with filename1 = the name of the file you want to use as input
%              filename2 = the name of the file you want to use as output
%                     ni = number of inputs
%                     no = number of outputs
%                 system = 0 for non-integrating systems and 1 for integrating systems
%                   delt = time between stepweights
%
%          Example : dat2step('file1.dat', 'file2.dat', 3, 3, [0,1,0], 2)
%
function result = dat2step(filename1, filename2, ni, no, system, delt)
%
% Written by: E.Kanters and H. de Bruin, 12-23-1994
% Modified by : P.B. Thonus, 21-08-2000

% load datafile
fid = fopen(filename1,'r');
teller = 1;
for nr=1:(ni*no)

   % read description
   str = fscanf(fid,'%s,%s');
   fprintf('reading %2d of %d : %s \n',nr,(ni*no),str);
   testresult = fscanf(fid,' %f, ');
   for teller=1:length(testresult)
      temporary(teller,nr) = testresult(teller);
   end
end   
fclose(fid);

% convert data to mpc format

r=1;
for i=2:length(temporary)-1
   for j=1:no
      for k=1:ni
         test1 = temporary(1,(j-1)*ni+k);
         test2 = (j-1)*ni+k;
         if (i >= temporary(1,(j-1)*ni+k)+2)
            test3 = temporary(temporary(1,(j-1)*ni+k),(j-1)*ni+k);
            test4 = temporary(1,(j-1)*ni+k);
            test5 = (j-1)*ni+k;
            result(r,k) = temporary(temporary(1,(j-1)*ni+k),(j-1)*ni+k);
         else
            result(r,k) = temporary(i,(j-1)*ni+k);
         end
      end
      r=r+1;
   end
end

% add additional information
for i=1:no
   result(r+i-1,1) = system(i);
end
result(r+no,1) = no;
result(r+no+1,1) = delt;

% write to file
fid = fopen(filename2,'w'); %filename2
for i=1:length(result)
   for p=1:ni
      fprintf(fid,' %10.4f ',result(i,p));
   end
   fprintf(fid,'\n');
end
fclose(fid);
% ready
