% fluid catalytic cracker simulation
% Literature:
%    Hovd, M. and Skogestad, S.
%    Procedure for regulatory control structure selection with
%    application to the FCC process, AIChEJ., 39, 1938, dec 1993
clc;
echo on;
clear all
% model
a=[-2.55e-2  1.51e-6 ;  2.27e+2 -4.10e-2];
b=[ 3.29e-6 -2.60e-5 ; -2.80e-2  7.80e-1]; 
c=[ 1.32e+3  5.59e-1 ; -4.42e+3  5.38e-1 ;  0.00e+0  1.00e+0];
d=[ 3.62e-1  0.00e+0 ;  0.00e+0  8.77e-1 ;  0.00e+0  0.00e+0]; 
e=[ 6.87e-7  0.00e+0  -7.06e-6  3.53e-2 ;
    2.47e-2  9.24e-3  -2.54e-1  0.00e+0];
f=[ 2.46e-1  0.00e+0  -2.53e-1  0.00e+0 ;
    0.00e+0  0.00e+0   0.00e+0  0.00e+0 ;
    0.00e+0  0.00e+0   0.00e+0  0.00e+0];

% merge the models
[a1,b1,c1,d1] = mpcparal(a,b,c,d,a,e,c,f);

% convert the state space model to a stepweights model
delt   = 10;   % sample time is 10 minutes
Tfinal = 450;  % calculate 45 step weights
fcc = ss2step(a1,b1,c1,d1,Tfinal,0,delt);

% plot the stepresponses, note that now [u3,u4,u5,u6]=[d1,d2,d3,d4]
plotstep(fcc);

% save the models to the file fcc.mat
save c:\matlabR13\work\fcc fcc
