% define the model in tf format
% gp = 1.87*exp(-20s)/(33s+1)
% gd = 6.01*exp(-18s)/(58s+1)
%
clear all
clc
gp = [0 1.87; 33 1; 0 20]
gd = [0 6.01; 58 1; 0 18]
%
% combine the models and convert them to mod format
% select a sampling interval of 10
%
delt = 10.0; 
plant = tfd2mod(delt,1,gp,gd);
%
% generate 30 stepweights
%
Tfinal = 300.0;
p11ff = mod2step(plant, Tfinal,delt);
%
% plot stepweight model and save model to a mat file
%
plotstep(p11ff)
save c:\matlabR13\work\p11ff p11ff;
