% define the model in tf format
% gp = 2.4*exp(-2s)(-6s+1)/(20s+1)
%
clear all
clc
echo  off
gp = [-14.4 2.4; 20 1; 0 2]
%
% convert the model to step format 
% select a sampling interval of 3
% generate 30 stepweights
%
Tend = 90.0;
delt = 3.0; 
p11nmp = tfd2step(Tend,delt,1,gp);
%
% 
% plot stepweight model and save model to a mat file
%
plotstep(p11nmp)
save c:\matlabR13\work\p11nmp p11nmp;
%
% define the controller parameters
%
P=5; M=3; uwt=[]; ywt=[1]; r=[1]; ulim=[]; ylim=[];
plant = p11nmp;
%
% and call the controller
%
[y,u] = cmpc(plant,p11nmp,ywt,uwt,M,P,Tend,r,ulim,ylim);
%
% plot the results
%
plotall(y,u,delt), pause
clc;
%
% now limit several points over the output horizon
%
% define the controller parameters
%
ylim=[-inf inf; -inf inf; -inf inf; -inf 0.75; -inf 0.75];
%
% call the controller again
%
[y,u] = cmpc(plant,p11nmp,ywt,uwt,M,P,Tend,r,ulim,ylim);
%
% plot the results
%
plotall(y,u,delt),pause
clc;
%
% now limit all points over the output horizon
%
% define the controller parameters
%
ylim=[-inf 0.75;-inf 0.75;-inf 0.75;-inf 0.75;-inf 0.75];
%
% call the controller
%
[y,u] = cmpc(plant,p11nmp,ywt,uwt,M,P,Tend,r,ulim,ylim);
%
% plot the results
%
plotall(y,u,delt),pause
