% general use of poly2tfd:
% g = poly2tfd(num, den, delt, delay);
% for continuous systems delt = 0
% poly2tfd can also be used for discrete systems in the same 
% fashion, delt is now the discretization interval
%
clear all
clc
echo off
%
g11=poly2tfd(5.53,[40 1],0,2);
g12=poly2tfd(3.66,[9   1],0,2);
g13=poly2tfd(1.65,[30 1],0,20);
g21=poly2tfd(7.20,[19 1],0,0);
g22=poly2tfd(4.38,[33 1],0,20);
g23=poly2tfd(4.42,[44 1],0,22);
g31=poly2tfd(6.90,[40 1],0,15);
g32=poly2tfd(5.39,[50 1],0,18);
g33=poly2tfd(5.72,[60 1],0,14);
%
% sampling interval is 6 minutes
% generate 40 stepweights
%
delt=6;
ny=3;
Tfinal=240;
p33 = tfd2step(Tfinal,delt,ny,g11,g21,g31,g12,g22,g32,g13,g23,g33);
plotstep(p33);
save c:\matlabR13\work\p33mod p33;
