% first create the models for the manipulated and disturbance variables
% from standard MATLAB poly format (z-transform) into the MPC tf format

clear all
clc
echo off
delt = 0.1417;

% process output 1:
gp11 = poly2tfd([0  0.1605],[1 -0.9856], delt, 1);
gp12 = poly2tfd([0  0.1576],[1 -0.8891], delt, 1);
gp13 = poly2tfd([0  0.7596 -0.8298 -0.05252 0.1306],[1 -0.9748 0 0 0], delt, 1);
gp14 = poly2tfd([0 -0.02269],[1 -0.9771], delt, 1);

% process output 2:
gp21 = poly2tfd([0  0.1644],[1 -0.9835], delt, 1);
gp22 = poly2tfd([0 -1.5776],[1 -0.9023], delt, 1);
gp23 = poly2tfd([0 -0.004463 0.03579],[1 -0.7091 0], delt, 1);
gp24 = poly2tfd([0 -0.001054 -0.001065],[1 -1.728 0.7324], delt, 1);

% convert the models from tf format into the MPC mod format
% ensure that the models are entered columnwise!!

ny = 2;
modelMF = tfd2mod(delt,ny,gp11,gp21,gp12, gp22, gp13, gp23, gp14, gp24);

% convert the models from mod format to step weight format

Tfinal = 50;
modelSF = mod2step(modelMF, Tfinal);
plotstep(modelSF)
save c:\matlabR13\work\polyeth.dat modelSF -ascii
plotstep(modelSF);
