% STEP2DAT converts MATLAB files in MPC format to MCPC stepweight files
%
%          Usage: model = step2dat(filename1, filename2, ni, no)
%
%         with filename1 = the name of the file you want to use as input
%					filename2 = the name of the file you want to use as output
%                     ni = number of inputs
%                     no = number of outputs
%
%			  Example : step2dat('invoer.dat','uitvoer.dat',3,3)
%
function temporary = step2dat(filename1, filename2, ni, no)
%
% Written by: P.B. Thonus, 21-08-2000


% load datafile
fid = fopen(filename1,'r'); %filename1
result = fscanf(fid,' %f ');
fclose(fid);

% initialisatie
rt = 1;
t = 2;

% make the correct matrix 
for i=1:(length(result)-(no*ni+2*ni))/(no*ni)
   for k=1:(ni*no)
      temporary(t,k)= result(rt+(k)-1);         
   end
   if (i >= (length(result)-(no*3+2*3))/(no*ni)-1)
      for k=1:(ni*no)
         temporary(1,k)= t;
      	temporary(t+1,k)= result(rt+(k)-1);         
   	end
   end
   t = t + 1;
   rt = rt + ni*no;
end

% open outputfile 
fid = fopen(filename2,'w'); %filename2

% write the matrix to file with correct format
kolom = 1;
for k=1:no
   for n=1:ni
      hr1 = 6;
      hr2 = 6;
      fprintf(fid,'(y%d,u%d)\n',k,n);
      fprintf(fid,'%10g, ',temporary(1,kolom));
      for i=2:t
         fprintf(fid,'%10.4f',temporary(i,kolom));
         if (hr1 == i)
            if (i == t)
               fprintf(fid,'');
               break;
            end
            fprintf(fid,',\n');
            hr1 = hr1 + hr2;
         else
            if (i < t)
               fprintf(fid,', ');
            end
         end
      end
      kolom = kolom + 1;
      fprintf(fid,'\n');
   end
end
fclose(fid);
% ready
