function f = errordef(X,Cvalue,Tvalue,cAnew,Tnew,Tcjnew,Convtgt,Temptgt,pmmC,pmmT)
%
% process parameters according to the article of Dayal et al.
%
global Ah cAfeed cps cpw Ea dHr R Tin Tfeed V Vcj rhos rhow delt;
%
k0 = 4E8; U = 30.0;
%
alfaC  = 0.1;    % filter constant conversion  - setpoint trajectory
alfaT  = 0.1;    % filter constant temperature - setpoint trajectory
gammaC = 400.0;  % weighting coefficient for conversion
gammaT = 1.0;    % weighting coefficient for temperature
sumC   = 0.0;    % initial value 
sumT   = 0.0;    % initial value
%
% calculate the prediction horizon
%
hor1 = 4 + (-5/log(alfaC));
hor2 = 3 + (-5/log(alfaT));
% P = round(2*max(hor1,hor2));
P = 12;
%
% the old prediction values equal to the current process measurement
%
cApredold  = cAnew; 
Tpredold   = Tnew;    
Tcjpredold = Tcjnew;
Convspold  = Cvalue;
Tempspold  = Tvalue;
%
% calculation of the sum of errors between setpoint trajectory
% and process model predictions over a horizon P
%
for j = 1:P
%
% calculation of the setpoint trajectory
%
    Convspnew = alfaC*Convspold + (1-alfaC)*(Convtgt-pmmC);
    Tempspnew = alfaT*Tempspold + (1-alfaT)*(Temptgt-pmmT);
    Convspold = Convspnew;
    Tempspold = Tempspnew;
%
% store the new starting values of the trajectory for the next 
% controller execution. Since the controller executes every 4 cycles,
% this needs to be done at j=4
%
    if j==4
        Cvalue = Convspnew;
        Tvalue = Tempspnew;
    end
%
% calculation of the process model predictions
% 
    ratepred    = V*k0*cApredold*exp(-Ea/(R*Tpredold));
    cAprednew   = cApredold + (X(1)*(cAfeed-cApredold)-ratepred)*delt;
    Tprednew    = Tpredold + (X(1)*(Tfeed-Tpredold)/V + dHr*ratepred/(rhos*cps) + ...
                  ((U*Ah)/(V*rhos*cps))*(Tcjpredold-Tpredold))*delt;
    Tcjprednew  = Tcjpredold + (X(2)*(Tin-Tcjpredold)/(Vcj*rhow) + ...
                  ((U*Ah)/(Vcj*rhow*cpw))*(Tpredold-Tcjpredold))*delt;
    cApredold   = cAprednew;
    Tpredold    = Tprednew;
    Tcjpredold  = Tcjprednew;
    Convprednew = 1 - cAprednew/cAfeed;
%
% calculation of the sum of errors 
%
    sumC = sumC + j*(Convspnew - Convprednew)*(Convspnew - Convprednew);
    sumT = sumT + j*(Tempspnew - Tprednew)*(Tempspnew - Tprednew);  
end
f = gammaC*sumC + gammaT*sumT;  
% end of code               
