function out = nlmvc(u)

% u   = [Convsp; Trsp]
% Fcw = the cooling water flow rate
% Fi  = the inlet feed flow rate

Convsp = u(1);
Trsp   = u(2);
Conv   = u(3);
Temp   = u(4);

errorC = Convsp - Conv;
errorT = Trsp - Temp;
%
k0 = 4E8;
UA = 150.0;
%
V     = 1.0;
rhocp = 1551.0;
delH  = 140.0;
cpw   = 4.181;
cAin  = 866.0;
Tfeed = 293.0;
Twin  = 290.0;
E     = 6E4;
R     = 8.314;
delt  = 20.0;
%
% model equations
%
cA     = cAin*(1-Convsp);
rate   = k0*cA*exp(-E/(R*Trsp));
Fi     = (-cAin*errorC/delt + rate)/(cAin-cA);
Tw     = (rhocp/UA)*(-Fi*(Tfeed-Trsp)+V*errorT/delt)-(delH/UA)*rate+Trsp;
Fcw    = UA*(Tw-Trsp)/(cpw*(Twin-Tw));
%
if Fi <= 0.007
    Fi = 0.0007;
elseif Fi >= 0.03
    Fi = 0.03;
end
if Fcw <= 9.0
    Fcw = 9.0;
elseif Fcw >= 40.0
    Fcw = 30.0;
end

[out] = [Fi Fcw];
% end of code 