% Main program phrtc
%
% process parameters according to the article of MacGregor
% define the process parameters global, except for k0 and U
% since they need to be changed to create process/model mismatch
%
clear all
clc
echo off
global Ah cAfeed cps cpw Ea dHr R Tin Tfeed V Vcj rhos rhow delt;
Ah     = 5.0;
cAfeed = 866.0;
cps    = 1.791;
cpw    = 4.181;
Ea     = 60000;
dHr    = 140.0;
R      = 8.314;
Tin    = 290.0;
Tfeed  = 293.0;
V      = 1.0;
Vcj    = 0.2;
rhos   = 866.0;
rhow   = 998.0;
delt   = 5.0;
%
% initial conditions
%
Fiold   = 0.014123;  % reactor feed at t=0
mdotold = 18.464;    % cooling water flow at t=0
Tpold   = 305.0;     % reactor process temperature at t=0
cApold  = 346.4;     % reactor process concentration at t=0
Tcjpold = 299.9;     % jacket process temperature at t=0
Tmold   = 305.0;     % reactor model temperature at t=0
cAmold  = 346.4;     % reactor model concentration at t=0
Tcjmold = 299.9;     % jacket model temperature at t=0
Tvalue  = 305.0;     % initial value setpoint trajectory        
Cvalue  = 0.6;       % initial value setpoint trajectory 
Convtgt = 0.6;       % initial conversion target
Temptgt = 310.0;     % initial temperature target (ss = 305)
X(1)    = Fiold;     % reactor feed at t=0
X(2)    = mdotold;   % cooling water flow at t=0
%
for i = 1:9
    Trdpold(i) = Tpold;
    Trdmold(i) = Tmold;
end
for i = 1:21
    Convdpold(i) = Cvalue;
    Convdmold(i) = Cvalue;
end
%
% calculation of the process - (360*delt) seconds
%
for i = 1:360
    Time(i) = 5*i;
    i
    if i >= 120
        Convtgt = 0.7;
    end
    if i >= 240
        Temptgt = 305.0;
    end
%
% trend the setpoints
%
   Convtg(i) = Convtgt;
   Temptg(i) = Temptgt;
%
% the output of the function PROCESS calculates the new values of the 
% concentration, temperature and jacket temperature of the process
% they are shifted one cycle for use in the next integration step
%
    [cApold,Tpold,Tcjpold,Trdpold,Convdpold] = ...
         process(cApold,Tpold,Tcjpold,Fiold,mdotold,Trdpold,Convdpold);
      
% the output of the function MODEL calculates the new values of the 
% concentration, temperature and jacket temperature of the model
% they are shifted one cycle for use in the next integration step
%
    [cAmold,Tmold,Tcjmold,Trdmold,Convdmold] = ...
       model(cAmold,Tmold,Tcjmold,Fiold,mdotold,Trdmold,Convdmold);
%    
% store Conv and Temp for trending purposes
%
    Conv(i) = Convdpold(21);
    Temp(i) = Trdpold(9);
%
% calculate the process-model mismatch. The correctness has to be 
% verified first before it is used in the setpoint trajectory equation
%
    pmmC = Convdpold(21) - Convdmold(21);
    pmmT = Trdpold(9) - Trdmold(9);
%
% control is done every 20 seconds
%
    if mod(i,4)==0    
% 
% calculation of the minimum of a nonlinear multivariable function
%
    options = optimset('tolX', [2E-5; 2E-5],'MaxFunEvals',1E7,'MaxIter',1E7);
    X    = fminsearch('errordef',[Fiold; mdotold],options,Cvalue,Tvalue,...
                       cAmold,Tmold,Tcjmold,Convtgt,Temptgt,pmmC,pmmT);
    end
%
if X(1) <= 0 
   X(1) = 0;
end
if X(2) <= 0
   X(2) = 0;
end    
Fiold   = X(1);
mdotold = X(2);
Feed(i) = X(1);
Fcw(i)  = X(2);
end
figure(1)
subplot(2,1,1), plot(Time,Conv,Time,Convtg);
xlabel('time (seconds)');
ylabel('Conversion');
subplot(2,1,2), plot(Time,Temp,Time,Temptg);
xlabel('time (seconds)');
ylabel('Temperature (K)');
pause
subplot(2,1,1), plot(Time,Feed);
xlabel('time (seconds)');
ylabel('Fin (m^{3}s^{-1})');
subplot(2,1,2), plot(Time,Fcw);
xlabel('time (seconds)');
ylabel('Fw (kgs^{-1})');
% end of code
