function [cAnew,Tnew,Tcjnew,Trdnew,Convdnew] = ...
         process(cAold,Told,Tcjold,Fiold,mdotold,Trdold,Convdold)  
%
% process parameters are defined in the article of MacGregor
% cAold    = concentration component A at time k-1
% Told     = reactor temperature at time k-1
% Tcjold   = cooling water temperature at time k-1
% Fiold    = reactor feed at time k-1
% mdotold  = cooling water flow at time k-1
% Trdold   = reactor temperature delay table imported
% Convdold = conversion delay table imported
% cAnew    = concentration component A at time k
% Tnew     = reactor temperature at time k
% Tcjnew   = cooling water temperature at time k
% Trdnew   = reactor temperature delay table exported
% Convdnew = conversion delay table exported
%
global Ah cAfeed cps cpw Ea dHr R Tin Tfeed V Vcj rhos rhow delt;
%
k0 = 4E8; U = 30.0;
%
rate     = V*k0*cAold*exp(-Ea/(R*Told));
cAnew    = cAold + (Fiold*(cAfeed-cAold)-rate)*delt;
Tnew     = Told + (Fiold*(Tfeed-Told)/V + dHr*rate/(rhos*cps) + ...
           ((U*Ah)/(V*rhos*cps))*(Tcjold-Told))*delt;
Tcjnew   = Tcjold + (mdotold*(Tin-Tcjold)/(Vcj*rhow) + ...
           ((U*Ah)/(Vcj*rhow*cpw))*(Told-Tcjold))*delt;
%
% set up a delay table for the measured variables and shift them each
% time step, the temperature has 40 sec delay, the conversion 100 sec
%
for i = 9:-1:2
    Trdold(i) = Trdold(i-1);
end
Trdold(1) = Tnew;
Trdnew    = Trdold;
%
for i = 21:-1:2
    Convdold(i) = Convdold(i-1);
end
Convdold(1) = 1-cAnew/cAfeed;
Convdnew    = Convdold;
%
% end of process description
%