# GASOLINE BLENDING OPTIMIZATION USING LINEAR PROGRAMMING - BLEND.MOD
       
set PROD;	        			# products
set COMP;		        		# components
set QUAL;		        		# qualities

param ValueLSR >= 0;			# sales price for lsr in ECU per m3
param LSRSale >= 0;				# lsr to sales

param MinProdVol{PROD} >=0;		# minimum volume of each product, m3
param MaxProdVol{PROD} >=0;		# maximum volume of each product, m3
param Value{PROD} >=0;			# sale price of each product, ECU per m3

param Cost{COMP} >=0;			# price of each component, ECU per m3
param MaxCompVol{COMP} >= 0;	# maximum volume of each component (total
								# to both blends, m3
param Quality{COMP, QUAL} >= 0;	# component blending qualities

param MaxQual{PROD,QUAL} >= 0; 	# maximum blending qualities
param MinQual{PROD,QUAL} >= 0;	# minimum blending qualities

var CompFlow{PROD,COMP} >= 0;	# flow of each component to each product
var ProdFlow{PROD} >= 0;		# flow of each product
var Product_Sales;				# revenue from product sales
var Production_Costs;			# production costs


maximize profit:
	Product_Sales - Production_Costs + LSRSale * ValueLSR;

subject to def_Product_Sales:
	Product_Sales = sum{i in PROD} ProdFlow[i] * Value[i];

subject to def_Proction_Costs:
	Production_Costs = sum{i in PROD, j in COMP} CompFlow[i,j]*Cost[j];

# availability constraint:
subject to AvaCon{j in COMP}:
	sum{i in PROD} CompFlow[i,j] <= MaxCompVol[j];

# component product mass balance:
subject to CoProMaBal{i in PROD}:
	sum{j in COMP} CompFlow[i,j] = ProdFlow[i];

# maximum production constraint:
subject to MaProCon{i in PROD}:
	ProdFlow[i] <= MaxProdVol[i];

# minimum production constraint:
subject to MiProCon{i in PROD}:
	ProdFlow[i] >= MinProdVol[i];

# LSR mass balance
subject to LSRMaBal:
	sum{i in PROD} CompFlow[i,"LSR_NAPHTA"] + LSRSale <=
                       MaxCompVol["LSR_NAPHTA"];

# quality * flow compared to maximum limit
subject to MaQuaFlo{i in PROD, k in QUAL}:
	sum{j in COMP} CompFlow[i,j] * Quality[j,k] <=
                       MaxQual[i,k] * ProdFlow[i];

#quality * flow compared to minimum limit
subject to MiQuaFlo{i in PROD, k in QUAL}:
	sum{j in COMP} CompFlow[i,j] * Quality[j,k] >=
	                       MinQual[i,k] * ProdFlow[i];

