# OPTIMIZATION OF A TRAIN OF TWO DISTILLATION TOWERS

param p1>=0;                  # value flow x1
param p2>=0;                  # value flow x2
param p4>=0;                  # value flow x4
param p5>=0;                  # value flow x5
param pu>=0;                  # utility cost
param F1max>=0;				  # maximum feed to column 1
param F4max>=0;				  # maximum value F4
param F4min>=0;				  # minimum value F4
param alfa>=0;				  # feed distribution column 1
param beta>=0;				  # restriction column 2
param gamma>=0;				  # restriction column 2
var F1>=0, <=F1max;           # column 1 feed
var F2>=0;	              	  # column 1 overhead
var F3>=0;                    # column 2 feed
var F4>=F4min, <=F4max;       # column 2 overhead
var F5>=0;                    # column 2 bottom

maximize profit:
        -p1*F1+p2*F2+p4*F4+p5*F5-pu*(F1+F3);

# mass balance column 1:
subject to Mbal1:
        F1 = F2 + F3;

# feed distribution column 1:
subject to Fdist:
        F2 = alfa*F1;

# mass balance column 2
subject to Mbal2:
        F3 = F4 + F5;

# overhead and bottom restrictions column 2:
subject to Restr1:
        F4 >= beta*F5;
subject to Restr2:
        F4 <= gamma*F5;

