# SIMPLE BLENDING PROBLEM file SMLBLEND.MOD

set PROD;			# products
set COMP;			# components
param Minprodvol{PROD} >= 0;	# minimum volume of each product, m3
param Maxprodvol{PROD} >= 0;	# maximum volume of each product, m3
param Value{PROD} >= 0;		    # sales price of each product, ECU per m3
param Maxqual{PROD} >= 0;	    # maximum octane number products
param Minqual{PROD} >= 0;	    # minimum octane number products
param Cost{COMP} >= 0;		    # price of each component, ECU per m3
param Maxcompvol{COMP} >= 0;	# maximum volume of each component,
				                # total to blends, m3
param Qual{COMP} >= 0;		    # octane number components

var Compflow{PROD,COMP} >= 0;	# flow of each component to each product
var Prodflow{i in PROD} >= Minprodvol[i], <= Maxprodvol[i];
								# flow of each product

maximize total_profit:
   sum {i in PROD, j in COMP} Compflow[i,j] * (Value[i] - Cost[j]);

# component availabilty constraint:
subject to AvailabilityConstraint {j in COMP}:
   sum {i in PROD} Compflow[i,j] <= Maxcompvol[j];

# component product mass balance:
subject to ProductBalance {i in PROD}:
   sum {j in COMP} Compflow[i,j] = Prodflow[i];

# compare quality*flow to maximum limit:
subject to Quality1 {i in PROD}:
   sum {j in COMP} Compflow[i,j] * Qual[j] <= Maxqual[i] * Prodflow[i];

# compare quality*flow to minimum limit:
subject to Quality2 {i in PROD}:
   sum {j in COMP} Compflow[i,j] * Qual[j] >= Minqual[i] * Prodflow[i];


