# References:
#
set ORIG;    # origins
set DEST;    # destinations

param supply{ORIG};              # amounts available at origin
param demand{DEST};              # amounts required at destinations

   check: sum {i in ORIG} supply[i] >= sum {j in DEST} demand[j];

param Unitcost >=0;              # shipping cost per case per 1000 miles
param distance{ORIG,DEST} >= 0;  # shipping distances

param cost{i in ORIG,j in DEST} := Unitcost * distance[i,j]/1000;

var   NoUnits{ORIG,DEST} >= 0;   # units to be shipped

minimize total_cost:
   sum {i in ORIG, j in DEST} cost[i,j] * NoUnits[i,j];

subject to Supply {i in ORIG}:
   sum {j in DEST} NoUnits[i,j] <= supply[i];

subject to Demand {j in DEST}:
   sum {i in ORIG} NoUnits[i,j] = demand[j];