set varin;
set varout;

param Inputinit{varin} >= 0;
param Inputmin{varin} >= 0;
param Inputmax{varin} >= 0;
param Outputinit{varout} >= 0;
param Outputmin{varout};
param Outputmax{varout} >= 0;
param Gain{varout,varin};

var Input{i in varin}, >= Inputmin[i], <= Inputmax[i];
var Output{i in varout}, >= Outputmin[i], <= Outputmax[i];

maximize Throughput:
        Output["DIST"];
# minimize Energy:
#       Output["TBT"];      

# process models
subject to Modeleqns{i in varout}:
	    Output[i] = Outputinit[i] + sum {j in varin} Gain[i,j] * 
                    (Input[j] - Inputinit[j]);
























