set varin;
set varout;

param Inputinit{varin} >= 0;
param Inputmin{varin} >= 0;
param Inputmax{varin} >= 0;
param Outputmin{varout};
param Outputmax{varout} >= 0;
param Gain{varout,varin};
param Outputinit{varout} >= 0;
param Tdiffmax >= 0;
param dPfrac >= 0;
param P5max >= 0;
param P6max >= 0;

var Input{i in varin}, >= Inputmin[i], <= Inputmax[i];
var Output{i in varout}, >= Outputmin[i], <= Outputmax[i];
var P5 >=0, <= P5max;
var P6 >=0, <= P6max;

maximize Throughput:
        Input["F1"] + Input["F2"] + Input["Fgo"] + Input["F4"];

# process models
subject to Modeleqns{i in varout}:
	    Output[i] = Outputinit[i] + sum {j in varin} Gain[i,j] * 
                    (Input[j] - Inputinit[j]);

# combustion constraint
subject to combust_con:
        Output["Tcyc"] - Output["Treg"] <= Tdiffmax;

# fractionator constraint
subject to fract_con:
        P5 = Input["P4"] - dPfrac;

# regenerator/reactor pressure balance
subject to press_bal:
        P6 = Input["P4"] - Input["dPRR"];


















