function varargout = median_filter_video(varargin)
% MEDIAN_FILTER_VIDEO M-file for median_filter_video.fig
%      MEDIAN_FILTER_VIDEO, by itself, creates a new MEDIAN_FILTER_VIDEO or raises the existing
%      singleton*.
%
%      H = MEDIAN_FILTER_VIDEO returns the handle to a new MEDIAN_FILTER_VIDEO or the handle to
%      the existing singleton*.
%
%      MEDIAN_FILTER_VIDEO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MEDIAN_FILTER_VIDEO.M with the given input arguments.
%
%      MEDIAN_FILTER_VIDEO('Property','Value',...) creates a new MEDIAN_FILTER_VIDEO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before median_filter_video_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to median_filter_video_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help median_filter_video

% Last Modified by GUIDE v2.5 30-Nov-2004 23:10:19

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @median_filter_video_OpeningFcn, ...
                   'gui_OutputFcn',  @median_filter_video_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before median_filter_video is made visible.
function median_filter_video_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to median_filter_video (see VARARGIN)

% Choose default command line output for median_filter_video
handles.output = hObject;

% initialize main window
subplot(handles.input_frame);
colormap(gray(255)); image(zeros(256)); axis off;
subplot(handles.noisy_frame);
colormap(gray(255)); image(zeros(256)); axis off;
subplot(handles.median_filtered_frame);
colormap(gray(255)); image(zeros(256)); axis off;

handles.mov = [];

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes median_filter_video wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = median_filter_video_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function mse_edit_Callback(hObject, eventdata, handles)
% hObject    handle to mse_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of mse_edit as text
%        str2double(get(hObject,'String')) returns contents of mse_edit as a double


% --- Executes during object creation, after setting all properties.
function mse_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to mse_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function psnr_edit_Callback(hObject, eventdata, handles)
% hObject    handle to psnr_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of psnr_edit as text
%        str2double(get(hObject,'String')) returns contents of psnr_edit as a double


% --- Executes during object creation, after setting all properties.
function psnr_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to psnr_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function program_edit_Callback(hObject, eventdata, handles)
% hObject    handle to program_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of program_edit as text
%        str2double(get(hObject,'String')) returns contents of program_edit as a double


% --- Executes during object creation, after setting all properties.
function program_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to program_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in browse_pushbutton.
function browse_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to browse_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[filename, pathname] = uigetfile('*.out', 'Pick DSP binary');
if ~isequal(filename, 0)
    set(handles.program_edit, 'String', fullfile(pathname, filename));
end


% --- Executes on button press in init_pushbutton.
function init_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to init_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

program_pathname = get(handles.program_edit, 'String');
if isempty(program_pathname)
    return;
else
    try
        hpi_img_xfer(program_pathname); % init communication
        set(handles.run_pushbutton, 'Enable', 'on');
    catch
        errordlg(lasterr, 'HPI Error');
    end
end

% --- Executes on button press in run_pushbutton.
function run_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to run_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isempty(handles.mov)
    errordlg('Please load in a movie from the File menu');
    return;
end

msg2target = uint32(256*256); % could be anything
                
how_much_noise = str2num(get(handles.noise_density_edit, 'String'));
           
% loop through every frame, and send down to the DSP
nframes = length(handles.mov);
try
    for ii=1:nframes
        % show the original frame
        f = rgb2gray(handles.mov(ii).cdata);
        subplot(handles.input_frame);
        image(f); axis off;
        set(handles.original_text, 'String', ...
            sprintf('Original Frame: %d of %d', ii, length(handles.mov)));
        % show the noisy frame
        fprime = imnoise(f, 'salt & pepper', how_much_noise);
        subplot(handles.noisy_frame);
        image(fprime); axis off;
        % have the DSP clean up the noisy video frame
        g = hpi_img_xfer(fprime, msg2target);
        % display denoised video frame
        subplot(handles.median_filtered_frame);
        image(g); axis off;
        drawnow
    end
catch
    errordlg(lasterr, 'video error');
end

% --------------------------------------------------------------------
function MenuFile_Callback(hObject, eventdata, handles)
% hObject    handle to MenuFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function MenuFileLoad_Callback(hObject, eventdata, handles)
% hObject    handle to MenuFileLoad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% load in AVI File
[filename, pathname] = uigetfile('*.avi', 'Pick AVI file');
if ~isequal(filename, 0)
    try
        handles.mov = aviread(fullfile(pathname,filename));
        guidata(hObject, handles); % Update handles structure
        % display 1st frame
        subplot(handles.input_frame);
        image(rgb2gray(handles.mov(1).cdata));
        axis off;
        set(handles.original_text, 'String', ...
            sprintf('Original Frame: 1 of %d', length(handles.mov)));
    catch
        errordlg(lasterr, 'AVI file I/O error');
    end
end

% --------------------------------------------------------------------
function MenuFileQuit_Callback(hObject, eventdata, handles)
% hObject    handle to MenuFileQuit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

button = questdlg('Quit Application?', 'Confirm Exit', 'Yes', 'No', 'No');
if 'Y'==button(1)
    clear functions;
    close(handles.MedianHPIVideo);
end



function noise_density_edit_Callback(hObject, eventdata, handles)
% hObject    handle to noise_density_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of noise_density_edit as text
%        str2double(get(hObject,'String')) returns contents of noise_density_edit as a double


% --- Executes during object creation, after setting all properties.
function noise_density_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to noise_density_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes during object creation, after setting all properties.
function MedianHPIVideo_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MedianHPIVideo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


