#include "stdafx.h"

using namespace Gdiplus;

GdiplusUtil GDIPLUS_UTIL; // ensures that GdiplusStartup() is called

GdiplusUtil::GdiplusUtil()
{
	// initialize GDI+
	GdiplusStartupInput gdiplusStartupInput;
	if (Ok != GdiplusStartup(&m_gdiplusToken, &gdiplusStartupInput, NULL))
		throw std::runtime_error("Failed to initialize GDI+");
}

GdiplusUtil::~GdiplusUtil()
{
	GdiplusShutdown(m_gdiplusToken); 
}

CString GdiplusUtil::getErrorString(Gdiplus::Status s)
{
	switch (s) {
		case Ok:
			return _T("no error");
		case GenericError:
			return _T("generic error");
		case InvalidParameter:
			return _T("invalid parameter");
		case OutOfMemory:
			return _T("out of memory");
		case ObjectBusy:
			return _T("object busy");
		case InsufficientBuffer:
			return _T("insufficient buffer");
		case NotImplemented:
			return _T("not implemented");
		case WrongState:
			return _T("wrong state");
		case Aborted:
			return _T("aborted");
		case FileNotFound:
			return _T("file not found");
		case ValueOverflow:
			return _T("value overflow");
		case AccessDenied:
			return _T("access denied");
		case UnknownImageFormat:
			return _T("unknown image format");
		case FontFamilyNotFound:
			return _T("font family not found");
		case FontStyleNotFound:
			return _T("font style not found");
		case NotTrueTypeFont:
			return _T("not true type font");
		case UnsupportedGdiplusVersion:
			return _T("unsupported GDI+ version");
		case GdiplusNotInitialized:
			return _T("GDI+ not initialized");
		case PropertyNotFound:
			return _T("property not found");
		case PropertyNotSupported:
			return _T("property not supported");
		default:
			{
				CString sErr;
				LPVOID lpMsgBuf;
				if (!FormatMessage( 
					FORMAT_MESSAGE_ALLOCATE_BUFFER | 
					FORMAT_MESSAGE_FROM_SYSTEM | 
					FORMAT_MESSAGE_IGNORE_INSERTS,
					NULL,
					::GetLastError(),
					MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
					(LPTSTR) &lpMsgBuf,
					0,
					NULL ))
				{
					sErr = _T("Unable to extract Win32 error code");
				}
				else
                    sErr = CString((LPCTSTR)lpMsgBuf);

				LocalFree(lpMsgBuf);
				return sErr;
			}
	}
}

ColorPalette *GdiplusUtil::get8bppGrayScalePalette()
{
	static ColorPalette *p8bppGrayColorPalette = NULL;

	if (!p8bppGrayColorPalette) { // initialize palette

		p8bppGrayColorPalette = (ColorPalette *)malloc( sizeof(ColorPalette) + 256*sizeof(ARGB) );
		p8bppGrayColorPalette->Flags = PaletteFlagsGrayScale;
		p8bppGrayColorPalette->Count = 256;
		for (int ii=0; ii<256; ii++)
			p8bppGrayColorPalette->Entries[ii] = Color::MakeARGB(255,ii,ii,ii);

	}

	return p8bppGrayColorPalette;
}