#ifndef _IMAGE_8BPP_H_
#define _IMAGE_8BPP_H_

#include <gdiplus.h>
#include "ippi.h"

class Image8bpp {

public:

	// ctor that reads in pixel data from a file
	Image8bpp(const CString &filename);

	Image8bpp(const Image8bpp &other);

	~Image8bpp();

	Image8bpp &operator=(const Image8bpp &rhs);

	// draw the image to the control 
	void render(HWND hwnd);

	// accessor method for bitmap width
	int getWidth() const {
		return m_pBitmap->GetWidth();
	}

	// accessor method for bitmap height
	int getHeight() const {
		return m_pBitmap->GetHeight();
	}

	// accessor method for bitmap stride, or step-size
	int getStride() const {
		return m_stride;
	}

	// accessor method for image pixels
	Ipp8u *getPixels() const {
		return m_pPixels;
	}

private:

	// helper method called by copy ctor & assignment operator
	void copy(const Image8bpp &src);

	// GDI+ object used for file I/O and rendering purposes
    Gdiplus::Bitmap *m_pBitmap;
	
	// image pixels aligned to a 32-byte boundary, as required by the Intel IPP library
	Ipp8u *m_pPixels;

	// byte offset between one scan line and the next, not necessarily a multiple of
	// the width of the image, due to memory alignment issues
    int m_stride;

};

#endif // _IMAGE_8BPP_H_