#include <board.h> /* EVM library */
#include <stdio.h> /* printf() */
#include <dsp_fir_gen.h>
#include <time.h> /* clock() */

#include "..\image.h" /* image\kernel dimensions, example pixel data */
#pragma DATA_ALIGN (in_img, 4);
#pragma DATA_SECTION (in_img, "SBSRAM");

#pragma DATA_ALIGN (fir_output, 4);
#pragma DATA_SECTION (fir_output, "SBSRAM"); 
short fir_output[N_PIXELS]; /* output of DSP_fir_gen */

#pragma DATA_ALIGN (out_img, 4);
#pragma DATA_SECTION (out_img, "SBSRAM"); 
unsigned char out_img[N_PIXELS]; /* filtered image */

/* filter coefficients in Q15 format */
#define BOUNDARY (NH/2) /* "kernel offset" or half-width */
short h[NH] = {1310, 1310, 1310, 1310, 1310}; /* (1/25 * 2^15) */

void filter_image()
{
  int irow, icol, ii;
  short *pFirBand[NH], /* ptr to the FIR filtered row of pixels */
        sum; /* accumulator */
  unsigned char *p; /* ptr into the output image array */

  /* filter all of the rows */
  DSP_fir_gen(in_img, h, fir_output, NH, N_PIXELS);
  
  /* 1st BOUNDARY rows are zero */
  memset(in_img, 0, sizeof(char)*BOUNDARY*Y_SIZE);

  /* 
   * walk down the column dimension, thereby
   * performing the 2D filtering operation.
   */
  for (irow=BOUNDARY; irow<X_SIZE-BOUNDARY; ++irow) {
    for (ii=0; ii<NH; ++ii)
	  pFirBand[ii] = fir_output + (irow-BOUNDARY+ii)*Y_SIZE;
	  
	/* 1st BOUNDARY cols are zero */
	p = out_img + irow*Y_SIZE;
	for (ii=0; ii<BOUNDARY; ++ii)
	  *p++ = 0;

	for (icol=0; icol<X_SIZE-2*BOUNDARY; ++icol) {
	  sum = 0;
	  for (ii=0; ii<NH; ++ii)
	    sum += *(pFirBand[ii])++;
	  *p++ = sum; /* >>15 performed within DSP_fir_gen */
	}
	
	/* last BOUNDARY cols are zero */
	for (ii=0; ii<BOUNDARY; ++ii)
	  *p++ = 0;	
  }
}

int main(void)
{
  clock_t start, stop, overhead, t = 0; /* timing */
  const int N = 10; /* how many times to profile */
  int ii = 0;
      
  evm_init(); /* initialize the board */
  start = clock(); /* calculate overhead of calling clock*/
  stop = clock();  /* and subtract this value from The results*/
  overhead = stop - start;
	
  for (; ii<N; ++ii) {
    start = clock(); /* begin "profile area" */
      filter_image();
    stop = clock(); /* end "profile area" */
    t += stop-start-overhead;
    printf("# cycles to filter image: %d\n", stop-start-overhead);
  }
  
  printf("avg time is %.2f cycles.\n", (float)t/(float)N);
}
