-heap 0x100000
-stack 0x400

/* Memory map definition */
MEMORY
{
  IPRAM : origin = 0x00000000 length = 0x00010000
  IDRAM : origin = 0x80000000 length = 0x00010000
  SBSRAM : origin = 0x00400000 length = 0x00040000
  SDRAM0 : origin = 0x02000000 length = 0x00400000
  SDRAM1 : origin = 0x03000000 length = 0x00400000
}

/* Bind various sections into the different areas of memory */
SECTIONS
{
  .vec:          load = 0x00000000		/* Interrupt vector table */
  .text:         load = IPRAM			/* Code */
  .const:        load = IDRAM			/* Variables defined with const */
  .bss:          load = IDRAM			/* Global variables */
  .data:         load = IDRAM
  .cinit         load = SBSRAM
  .pinit         load = IDRAM
  .stack         load = IDRAM			/* Stack (for local variables) */
  .far           load = SDRAM0			/* Variables defined with far */
  .sysmem        load = SDRAM0			/* Heap: malloc and friends */
  .cio           load = IDRAM
  .ipmtext		 load = IPRAM			
}
