#ifndef _MEDIAN_FILTER_H_
#define _MEDIAN_FILTER_H_

#include "ippi.h"

// forward decls
class Image8bpp;

class MedianFilter {

public:

	// for switching between different implementations 
	// of the underlying algorithm
	typedef enum { IPP=0, QSORT=1, STL_SORT=2, FIXED_3x3=3, FIXED_5x5=4 } Implementation;

	MedianFilter(int kernelSize);

	// returns # microseconds to filter image, 0.0 if error occurred
	float processImage(Image8bpp *pNoisyImage, 
                       Image8bpp *pProcessedImage, 
					   Implementation impl);

	// accessor method for "kernel half-width"
	int getKernelHalfWidth() {
		return m_khw;
	}

private:

	// uses ippiFilterMedian_8u_C1R
	void processImageIpp(Image8bpp *pNoisyImage, Image8bpp *pProcessedImage);

	// uses std C library function qsort() to order pixels in neighborhood
	void processImageQsort(Image8bpp *pNoisyImage, Image8bpp *pProcessedImage);

	// qsort needs a comparison function, static method because qsort is a C function
	static int compare(const void *pElem1, const void *pElem2);

	// uses STL sort() function order pixels in neighborhood
	void processImageSTLsort(Image8bpp *pNoisyImage, Image8bpp *pProcessedImage);

	// optimized 3x3 median filter
	void processImage3x3(Image8bpp *pNoisyImage, Image8bpp *pProcessedImage);

	// optimized 5x5 median filter
	void processImage5x5(Image8bpp *pNoisyImage, Image8bpp *pProcessedImage);

	// helper method that converts timer counts into user time (us)
	float calcMicroSecs(LARGE_INTEGER start, LARGE_INTEGER stop); 

	int m_kernelSize,
		m_khw; // Kernel Half Width

	LARGE_INTEGER m_start, m_stop; // timing
    float m_freq; // frequency of the high-resolution performance counter 

};

#endif // _MEDIAN_FILTER_H_