accum = 1311; % example sum of pixel intensities for 3x3 neighborhood
sumsq = 194199; % example sum of squares for same neighborhood
Q = 12; % Q factor for fixed-point arithmetic

% floating-point
variance_floating_point = (sumsq/9) - (accum/9)*(accum/9);
disp(sprintf('Floating point: %.3f - %.3f^2 = %.3f', ...
    (sumsq/9), (accum/9), variance_floating_point));

% fixed-point (1)
% u = (accum*S) >> Q;
% v = (sumsq*S) >> Q;
% variance_fixed_point1 = v - u*u;
S = round(1/9 * 2^Q);
term1 = bitshift(sumsq*S,-Q); % sumsq*455 >> 12
term2 = bitshift(accum*S,-Q); % accum*455 >> 12
variance_fixed_point1 = term1 - term2*term2;
disp(sprintf('Fixed point #1 = %d - %d^2 = %d', ...
    term1, term2, variance_fixed_point1));
disp(sprintf('Fixed point #1 |delta| = %f', ...
    abs(variance_floating_point-variance_fixed_point1)));

% fixed-point (2): different order of operations
% usq = (accum*S)*(accum*S)
% variance_fixed_point1 = (sumsq*S - usq>>Q) >> Q
term1 = sumsq*S; 
term2 = accum*S * accum*S;
term2 = bitshift(term2, -Q);
variance_fixed_point2 = bitshift(term1 - term2, -Q);
disp(sprintf('Fixed point #2 = %d - %d^2 = %d', ...
    term1, term2, variance_fixed_point2));
disp(sprintf('Fixed point #2 |delta| = %f', ...
    abs(variance_floating_point-variance_fixed_point2)));
