function J = sobel_edge_detect_fixed(I, T)

I = double(I);

% compute gradient image
Gx = filter2([1 0 -1;2 0 -2;1 0 -1], I, 'valid');
Gy = filter2([-1 -2 -1;0 0 0;1 2 1], I, 'valid');
G = abs(Gx) + abs(Gy);

J = logical(zeros(size(G))); % return matrix

% if T is not a string, client specified fixed threshold
if isa(T, 'char')          
    % histogram of gradient image
    max_gradient = max(G(:));
    bins = 0:max_gradient;
    H = histc(G(:),bins)';
    % zero-phase smoothing of the histogram (so peaks don't shift)
    H_smoothed = conv(H, [1 1 1 1 1]./5);
    H(2:length(H)) = H_smoothed(5:length(H_smoothed)-1);
            
    % isodata algorithm
    nh = length(H);
    T_prev = -1;
    T = round(max_gradient/2);
    kk = 1;
    while (T_prev ~= T) & (kk <= 10)
        % mean (center-of-mass) above T
        mhi = sum(bins(T:nh).*H(T:nh)) ./ sum(H(T:nh));
        % mean (center-of-mass) below T
        mlo = sum(bins(1:T-1).*H(1:T-1)) ./ sum(H(1:T-1));
        T_prev=T;
        T=round((mhi+mlo)/2);
        kk=kk+1;
    end
end

indices = find(G > T);
J(indices) = true;
