#include <rtdx.h> 	/* target API */
#include <stdio.h> 
#include <IMG_sobel.h>
#include <IMG_thr_le2min.h>     
#include "target.h" /* defines TARGET_INITIALIZE() */
#include "image.h"  /* dimensions */

RTDX_CreateInputChannel(ichan); /* input image & T come down this pipe */
RTDX_CreateOutputChannel(ochan); /* processed image back through this pipe */

#pragma DATA_SECTION(img_buf1, "SDRAM");
#pragma DATA_ALIGN (img_buf1, 8);
unsigned char img_buf1[N_PIXELS];

#pragma DATA_SECTION(img_buf2, "SDRAM");
#pragma DATA_ALIGN (img_buf2, 8);
unsigned char img_buf2[N_PIXELS];

static void sobel_edge_detect(unsigned char T)
{
  /* 
   * input & output buffers for IMG_thr_le2min may NOT
   * alias (see IMG_thr_le2min docs), thus operation 
   * cannot be done "in-place".
   */
  IMG_sobel(img_buf1, img_buf2, Y_SIZE, X_SIZE);
  IMG_thr_le2min(img_buf2, img_buf1, Y_SIZE, X_SIZE, T);
}

void main()
{
  int status, T, ii;
  
  TARGET_INITIALIZE();
  while (!RTDX_isInputEnabled(&ichan))
    ;/* wait for channel enable from MATLAB */
  while (!RTDX_isOutputEnabled(&ochan))
    ;/* wait for channel enable from MATLAB */
  printf("Input & Output channels enabled ...\n");
  
  while (1) {
    /* wait for the host to send us a threshold */
    if (sizeof(T) != (status = RTDX_read(&ichan, &T, sizeof(T))))
      printf("ERROR: RTDX_read of threshold failed!\n");
    else
      printf("Received threshold (%d) from host\n", T);
      
    /* now we're expecting X_SIZE x Y_SIZE worth of image data */
    if (N_PIXELS != (status = RTDX_read(&ichan, img_buf1, N_PIXELS))) {
      printf("ERROR: RTDX_read of image failed (%d)!\n", status);
      exit(-1);
    }    
    printf("Received %dx%d image\n", X_SIZE, Y_SIZE);
     
    /* process the image */
    sobel_edge_detect((unsigned char)T);
    
    /* send it back to host */
    printf("Sending processed image data back to host ...\n");
    for (ii=0; ii<X_SIZE; ++ii) { 
      /* write one row's worth of data */
       if (!RTDX_write(&ochan, img_buf1+ii*Y_SIZE, Y_SIZE)) {
        printf("ERROR: RTDX_write of row %d failed!\n", ii);
        exit(-1);
      }
    } /* end (for each row) */
  }
}
