function J = sobel_edge_detect_fixed(I, T)
%
% SOBEL_EDGE_DETECT_FIXED   Sobel edge detection, with fixed threshold
%    J = SOBEL_EDGE_DETECT_FIXED(I, T)
%
%    J: binary segmented image, will be of type LOGICAL
%    I: input image
%    T: threshold
%

I = double(I);

% compute gradient image
Gx = filter2([1 0 -1;2 0 -2;1 0 -1], I, 'valid');
Gy = filter2([-1 -2 -1;0 0 0;1 2 1], I, 'valid');
G = abs(Gx) + abs(Gy);

J = logical(zeros(size(G))); % return matrix
indices = find(G > T);
J(indices) = true;