function P = permutation_matrix(N)
%
% PERMUTATION_MATRIX   returns permutation matrix of size NxN
%    P = PERMUTATION_MATRIX(N) forms its output P by rearranging
%    the identity matrix such that odd rows are grouped together,
%    first, followed by the even rows, i.e. 
%
%    P = [ row 1 of identity matrix
%          row 3 of identity matrix
%          ...
%          row (m/2)+1 of identity matrix
%          row 2 of identity matrix
%          row 4 of identity matrix
%          ...
%          row N of identity matrix ]
%
%    where N=2m
%

% Shehrzad Qureshi, shehrzad_q@hotmail.com
% 6/01
% You are free to use this code so long as you acknowledge its source.

I  = eye(N);
P  = zeros(N,N);

odd_indices = 1:2:N;
P(1:N/2,:) = I(odd_indices,:);

even_indices = 2:2:N;
P(N/2+1:N,:) = I(even_indices,:);