function save_ccs_data_file(I, filename)
%
% SAVE_CCS_DATA_FILE   save image matrix to CCStudio data file
%    SAVE_CCS_DATA_FILE(I, filename)
%
%    I: image matrix, must be UINT8 or UINT16
%    filename: name of CCStudio data file
%
% NOTE: data file is saved in hex format.
%

fid = fopen(filename, 'w+');
if -1 == fid
    error(['Failed to open ' filename]);
end

if strcmp('uint8', class(I))
    bpp = 8;
elseif strcmp('uint16', class(I))
    bpp = 16;
else
    error('Only 8-bit and 16-bit images are supported');
end

fprintf(fid, '1651 1 0 0 0\r\n');
[M N] = size(I);
I = double(I);
for ii=1:M
    if 8==bpp
        for jj=1:N/4
            fprintf(fid, '0x%.2x%.2x%.2x%.2x\r\n', I(ii, 4*jj:-1:4*(jj-1)+1));
        end   
    elseif 16==bpp
        for jj=1:N/2
            fprintf(fid, '0x00%.2x00%.2x\r\n', I(ii, 2*jj-1), I(ii, 2*jj));
        end   
    end
end % for each row

fclose(fid);