#include "stdafx.h"

// explicit instantiation of static class attributes
const int WindowLevel8bpp::N_LEVELS = 256;

WindowLevel8bpp::WindowLevel8bpp() : m_pLevels(NULL), m_pValues(NULL)
{
	int stepBytes; // not used
	m_pLevels = ippiMalloc_32s_C1(256, 1, &stepBytes);
	for (int ii=0; ii<N_LEVELS; ++ii)
		m_pLevels[ii] = ii;
	m_pValues = ippiMalloc_32s_C1(256, 1, &stepBytes); 
}

WindowLevel8bpp::~WindowLevel8bpp()
{
	if (m_pLevels)
		ippiFree(m_pLevels);
	if (m_pValues)
		ippiFree(m_pValues);
}

void WindowLevel8bpp::process(const Image8bpp *pIn, Image8bpp *pOut, int window, int level)
{
	// construct LUT
	int ii=0, jj=0, N=level - window/2;

	// 1st portion is all zeros
	if (N > 0) 
		for (; ii<N; ++ii)
			m_pValues[ii] = 0;
	
	// 2nd portion is a linear relationship
	float ratio = (float)(N_LEVELS-1)/(float)window;
	for (; jj<window; ++jj)
		m_pValues[ii+jj] = (Ipp32s)( (ratio*jj)+0.5 ); // +0.5 for rounding

	// 3rd portion is just all 255s
	ii += jj;
	for (; ii<N_LEVELS; ++ii)
		m_pValues[ii] = N_LEVELS-1;

	// apply LUT
	IppiSize roiSize = {pOut->getWidth(), pOut->getHeight()};
	IppStatus s = ippiLUT_8u_C1R(pIn->getPixels(),
		                         pIn->getStride(), 
								 pOut->getPixels(), 
								 pOut->getStride(), 
								 roiSize, 
								 m_pValues,
								 m_pLevels,
								 N_LEVELS);
	if (ippStsNoErr != s)
		throw std::runtime_error("LUT operation failed");
}