// WindowLevelDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WindowLevel.h"
#include "WindowLevelDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CWindowLevelDlg dialog



CWindowLevelDlg::CWindowLevelDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWindowLevelDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWindowLevelDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_IMAGE, m_image);
	DDX_Control(pDX, IDC_WINDOW_SLIDER, m_windowSlider);
	DDX_Control(pDX, IDC_LEVEL_SLIDER, m_levelSlider);
	DDX_Control(pDX, IDC_WINDOW_EDIT, m_txtWindow);
	DDX_Control(pDX, IDC_LEVEL_EDIT, m_txtLevel);
}

BEGIN_MESSAGE_MAP(CWindowLevelDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_LOAD, OnFileLoad)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_WINDOW_SLIDER, OnNMCustomdrawWindowSlider)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_LEVEL_SLIDER, OnNMCustomdrawLevelSlider)
END_MESSAGE_MAP()


// CWindowLevelDlg message handlers

BOOL CWindowLevelDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// setup the slider bars
	m_windowSlider.SetRange(1, 256);
	m_levelSlider.SetRange(0, 255);
	this->defaultSliderPos();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWindowLevelDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWindowLevelDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		try {

			if (m_apProcessedBitmap.get())
				m_apProcessedBitmap->render(m_image.GetSafeHwnd());

            CDialog::OnPaint();

		} catch (std::exception &e) {

			this->MessageBox(e.what(), _T("Draw Error"), MB_OK|MB_ICONERROR);
			this->EndDialog(IDOK);

		} catch (CException *e) {

			e->ReportError(MB_OK|MB_ICONERROR);
			this->EndDialog(IDOK);

		}
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWindowLevelDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CWindowLevelDlg::OnFileLoad()
{
	// prompt for image filename ...
	CFileDialog dlg(TRUE, // construct a File Load dialog
					_T(".bmp"),
					_T(""),
					OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT,
					_T("BMP Files (*.bmp)|*.bmp||"),
					NULL);

	try {

		if (IDOK == dlg.DoModal()) {
			m_apOrigBitmap = std::auto_ptr<Image8bpp>(new Image8bpp(dlg.GetPathName()));
			m_apProcessedBitmap = std::auto_ptr<Image8bpp>(new Image8bpp(*m_apOrigBitmap));
		}

		this->forceRedraw();

		// can adjust window/level now
		m_windowSlider.EnableWindow(TRUE);
		m_levelSlider.EnableWindow(TRUE);
		this->defaultSliderPos();

	} catch (std::exception &e) {

		this->MessageBox(e.what(), _T("Error"), MB_OK|MB_ICONERROR);

	}
}

void CWindowLevelDlg::OnNMCustomdrawWindowSlider(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	CString win;
	win.Format(_T("%d"), m_windowSlider.GetPos());
	m_txtWindow.SetWindowText((LPCSTR)win);
	this->winLevChanged(m_windowSlider.GetPos(), m_levelSlider.GetPos());
	*pResult = 0;
	this->forceRedraw();
}

void CWindowLevelDlg::OnNMCustomdrawLevelSlider(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	CString lev;
	lev.Format(_T("%d"), m_levelSlider.GetPos());
	m_txtLevel.SetWindowText((LPCSTR)lev);
	this->winLevChanged(m_windowSlider.GetPos(), m_levelSlider.GetPos());
	*pResult = 0;
	this->forceRedraw();
}

void CWindowLevelDlg::forceRedraw()
{
	// invalidating the control forces window to post the WM_PAINT
	// message, which eventually results in CWindowLevelDlg::OnPaint()
	// getting called.
	RECT rc;
	m_image.GetWindowRect(&rc);
	this->InvalidateRect(&rc);
}

void CWindowLevelDlg::defaultSliderPos()
{
	m_windowSlider.SetPos(256);
	m_txtWindow.SetWindowText(_T("256"));

	m_levelSlider.SetPos(127);
	m_txtLevel.SetWindowText(_T("256"));
}

void CWindowLevelDlg::winLevChanged(int W, int L)
{
	if (m_apOrigBitmap.get() && m_apProcessedBitmap.get())
        m_winLev.process(m_apOrigBitmap.get(), m_apProcessedBitmap.get(), W, L);
}