// WindowLevelDlg.h : header file
//

#pragma once
#include "afxwin.h"
#include "afxcmn.h"
#include "WindowLevel8bpp.h"

// forward declarations
class Image8bpp;

// CWindowLevelDlg dialog
class CWindowLevelDlg : public CDialog
{
// Construction
public:
	CWindowLevelDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_WINDOWLEVEL_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

// Implementation

	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnFileLoad();
	afx_msg void OnNMCustomdrawWindowSlider(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMCustomdrawLevelSlider(NMHDR *pNMHDR, LRESULT *pResult);
	DECLARE_MESSAGE_MAP()

private:

	// helper method that forces the OnPaint routine to be called
	void forceRedraw();

	// called from OnInitDialog() or whenever File|Load menu item is selected
	void defaultSliderPos();

	// whenever window or level changes, this method will be called
	void winLevChanged(int W, int L);

	CStatic m_image; // control that image is rendered onto
	CSliderCtrl m_windowSlider; // slider bar for window
	CSliderCtrl m_levelSlider; // slider bar for level
	CEdit m_txtWindow; // read-only edit control displaying current window
	CEdit m_txtLevel; // read-only edit control displaying current level

	std::auto_ptr<Image8bpp> m_apOrigBitmap, 
		                     m_apProcessedBitmap;

	WindowLevel8bpp m_winLev; // this object performs the actual window/level
};
