// AdaptiveFilterDlg.h : header file
//

#pragma once
#include "afxwin.h"


// CAdaptiveFilterDlg dialog
class CAdaptiveFilterDlg : public CDialog
{
// Construction
public:
	CAdaptiveFilterDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_ADAPTIVEFILTER_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnFileLoad();
	afx_msg void OnBnClickedFilterButton();
	DECLARE_MESSAGE_MAP()

private:

	CStatic m_origImage; // control that input image is rendered onto
	CStatic m_noisyImage; // control that corrupted image is rendered onto
	CStatic m_filteredImage; // control that the processed image is rendered onto
	CEdit m_mse; // mean-squared error fidelity metric
	CEdit m_psnr; // peak signal-to-noise ratio (in dB) fidelity metric

	std::auto_ptr<Image8bpp> m_apOrigBitmap,
		                     m_apNoisyBitmap,
		                     m_apProcessedBitmap;

	float m_noiseVariance; // control speckle noise magnitude

	CComboBox m_mmseKernelSize;
};
