function varargout = SobelDemo(varargin)
% SOBELDEMO M-file for SobelDemo.fig
%      SOBELDEMO, by itself, creates a new SOBELDEMO or raises the existing
%      singleton*.
%
%      H = SOBELDEMO returns the handle to a new SOBELDEMO or the handle to
%      the existing singleton*.
%
%      SOBELDEMO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SOBELDEMO.M with the given input arguments.
%
%      SOBELDEMO('Property','Value',...) creates a new SOBELDEMO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before SobelDemo_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to SobelDemo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help SobelDemo

% Last Modified by GUIDE v2.5 06-Aug-2004 08:38:16

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @SobelDemo_OpeningFcn, ...
                   'gui_OutputFcn',  @SobelDemo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before SobelDemo is made visible.
function SobelDemo_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to SobelDemo (see VARARGIN)

% Choose default command line output for SobelDemo
handles.output = hObject;

% initialize main window
subplot(handles.input_image);
colormap(gray(255)); image(zeros(200)); axis off;
subplot(handles.edge_image);
colormap(gray(255)); image(zeros(200)); axis off;

% Code Composer Link initialization (load & run project)
try
    handles.cc = ccsdsp('boardnum', 0); % initiate connection to target
    set(handles.cc,'timeout', 3); % set the CCSDSP timeout to 3s
    visible(handles.cc,1); % leave Code Composer Studio available to user
    target = 'C6416DSK'; % C6416DSK or C6701EVM
    projfile = [pwd '\..\Target\' target '\sobel_edge_detect.pjt'];
    projpath = fileparts(projfile);
    open(handles.cc, projfile);
    cd(handles.cc, projpath);
    build = 'Debug'; % Debug or Release
    load(handles.cc, [build '\sobel_edge_detect.out']);
    goto(handles.cc, 'main');

    % Initialize RTDX
    handles.image_size = [256 256]; % target code expects image of this size
    buflen = prod(handles.image_size);
    if buflen < 1024
        buflen = 1024; % min RTDX buflen is 1024 bytes
    end
    handles.cc.rtdx.configure(buflen, 1);
    handles.cc.rtdx.configure(buflen, 2);
    handles.cc.rtdx.open('ichan', 'w'); % open write channel
    handles.cc.rtdx.open('ochan', 'r'); % open read channel

    % Enable RTDX
    enable(handles.cc.rtdx);
    if 0 == isenabled(handles.cc.rtdx)
        error('Failed to enable RTDX.');
    end
    set(handles.cc.rtdx,'timeout', 3); % set RTDX timeout value to 3s
    run(handles.cc); % run target

    % ENABLE channels
    enable(handles.cc.rtdx, 'ichan');
    if 0 == isenabled(handles.cc.rtdx, 'ichan')
        error('Failed to enable target write channel.');
    end
    enable(handles.cc.rtdx, 'ochan');
    if 0 == isenabled(handles.cc.rtdx, 'ochan')
        error('Failed to enable target read channel.');
    end
catch
   errordlg(lasterr, 'CCS Link Error');
   delete(hObject);
end

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes SobelDemo wait for user response (see UIRESUME)
% uiwait(handles.SobelDemo);

% --- Outputs from this function are returned to the command line.
function varargout = SobelDemo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function threshold_edit_Callback(hObject, eventdata, handles)
% hObject    handle to threshold_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of threshold_edit as text
%        str2double(get(hObject,'String')) returns contents of threshold_edit as a double


% --- Executes during object creation, after setting all properties.
function threshold_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to threshold_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in edge_detect_button.
function edge_detect_button_Callback(hObject, eventdata, handles)
% hObject    handle to edge_detect_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

T = str2num(get(handles.threshold_edit, 'String'));

% get pointer to image data - I could just have easily created another
% field in the handles struct, but since it is held by a child of the axes
% object in the interest of reducing clutter I access it this way.
H = get(handles.input_image, 'Children');
I = get(H, 'CData');

% now pass I through the edge detector on the DSP
try
    set(gcf, 'Pointer', 'watch');
    % send threshold T over to the target DSP
    if iswritable(handles.cc.rtdx,'ichan'),
        writemsg(handles.cc.rtdx,'ichan', int32(T));
    else
        error('ichan not writable!');
    end

    % if the image isn't of size 256x256, resize it
    I = imresize(I, handles.image_size, 'bicubic');
    
    % target is now waiting for the image data
    % remember MATLAB is column-major but C is row-major
    J = I';
    writemsg(handles.cc.rtdx, 'ichan', uint8(J(:)));
    
    % let the DSP process it, and read the data back
    % enable read channel, and verify
    enable(handles.cc.rtdx,'ochan');
    if 0 == isenabled(handles.cc.rtdx,'ochan')
        error('Failed to enable read channel.');
    end

    % Query for number of available messages
    num_of_msgs = msgcount(handles.cc.rtdx,'ochan');
    
    % Read messages
    J = zeros(handles.image_size(1), handles.image_size(2));
    n_recvd = 1;
    while (handles.image_size(1)-n_recvd)>1
        for msg=1:num_of_msgs
            % read a single row and place it in the image matrix
            J(n_recvd,:) = readmsg(handles.cc.rtdx, 'ochan', 'uint8');
            n_recvd = n_recvd + 1;
        end
        num_of_msgs = msgcount(handles.cc.rtdx, 'ochan');
    end
    % 1st and columns, and last 2 rows contain meaningless data
    J(:,1) = 0; J(:,handles.image_size(2)) = 0;
    J(handles.image_size(1)-1,:) = 0;
    J(handles.image_size(1),:) = 0;
    J = logical(J); % target doesn't return a binary image

    subplot(handles.edge_image);
    imagesc(double(J).*255);
    axis off;
catch
    set(gcf, 'Pointer', 'arrow');
    errordlg(lasterr, 'Edge Detection Error');
end

set(gcf, 'Pointer', 'arrow');

% --------------------------------------------------------------------
function MenuFileLoad_Callback(hObject, eventdata, handles)
% hObject    handle to MenuFileLoad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

try
    % prompt user for input image filename
    [filename, pathname] = uigetfile( ...
        {'*.bmp;*.jpg;*.gif;*.tif', 'Image Files (*.bmp, *.jpg, *.gif, *.tif)';
        '*.bmp',  'Windows Bitmap Files (*.bmp)'; ...
        '*.jpg','JPEG Files (*.jpg)'; ...
        '*.gif','GIF Files (*.gif)'; ...
        '*.tif','TIFF (*.tif)'; ...
        '*.*',  'All Files (*.*)'}, ...
        'Select an image');
    
    if isequal(filename,0) | isequal(pathname,0)
        % do nothing, as the user clicked on cancel
    else
        % Remember that in C/C++, format strings use the \ character for
        % specifications (\t, \n, and so on) - so here replace all 
        % occurrences of \ with \\ so as not to confuse the MEX function.
        imgpath = strrep(fullfile(pathname,filename), '\', '\\');
        I = import_grayscale_image(imgpath);
        % display input image
        subplot(handles.input_image);
        imagesc(I);
        axis off;
        set(handles.edge_detect_button, 'Enable', 'on');
        % clear out the edge image
        subplot(handles.edge_image);
        colormap(gray(255)); image(zeros(200)); axis off;
    end
    
catch
    errordlg(lasterr, 'File I/O Error');
end

% --------------------------------------------------------------------
function MenuFile_Callback(hObject, eventdata, handles)
% hObject    handle to MenuFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


