#include "stdafx.h"
#include "RTDX.h"

using namespace Qureshi;
using namespace std;

RTDX::RTDX() 
{
	HRESULT hr = m_rtdxWrite.CreateInstance( __uuidof(RTDXINTLib::RtdxExp) );
	if (FAILED(hr))
		throw _com_error(hr);
	hr = m_rtdxRead.CreateInstance( __uuidof(RTDXINTLib::RtdxExp) );
	if (FAILED(hr))
		throw _com_error(hr);

	// open read and write channels
	if (0 != m_rtdxRead->Open("ochan", "R"))
		throw runtime_error("Failed to open RTDX read channel.");

	if (0 != m_rtdxWrite->Open("ichan", "W"))
		throw runtime_error("Failed to open RTDX write channel.");
}

RTDX::~RTDX()
{
	m_rtdxRead->Close();
	m_rtdxRead.Release(); 
	m_rtdxWrite->Close();
	m_rtdxWrite.Release();
}

void RTDX::sendInteger(int x)
{
	long bufferState;  // holds the state of the host's write buffer
	if (0 != m_rtdxWrite->WriteI4(x, &bufferState))
		throw runtime_error("WriteI4 failed.");
}

void RTDX::sendImage(Image8bpp *pImage)
{
	// send entire image in a single RTDX write message

	unsigned int nPixels = pImage->getHeight()*pImage->getWidth();
	VARIANT sa;                     // pointer to a SAFEARRAY
    SAFEARRAYBOUND rgsabound[1];    // dimensionality of the SAFEARRAY

	::VariantInit(&sa); // initialize VARIANT data structure
	sa.vt = VT_ARRAY | VT_I4; // SAFEARRAY of 32-bit integers
	rgsabound[0].lLbound = 0; // lower bound of the SAFEARRAY
	rgsabound[0].cElements = nPixels>>2; // upper bound of the SAFEARRAY
	sa.parray = SafeArrayCreate(VT_I4, 1, rgsabound); // instantiate SAFEARRAY
	
	// fill SAFEARRAY with pixel data
	unsigned char *pDst = NULL;
	HRESULT hr = SafeArrayAccessData(sa.parray, (void **)&pDst);
	if (FAILED(hr))
		throw _com_error(hr);

	if (Y_SIZE != pImage->getStride()) { // must copy on a row-by-row basis
		for (int iRow=0; iRow<pImage->getHeight(); ++iRow) {
			unsigned char *pSrc = pImage->getPixels() + iRow*pImage->getStride();
			memcpy(pDst+iRow*Y_SIZE, pSrc, Y_SIZE>>2); 
		}
	} else // a single copy suffices
		memcpy(pDst, pImage->getPixels(), nPixels);

	hr = SafeArrayUnaccessData(sa.parray);
	if (FAILED(hr))
		throw _com_error(hr);

	// now send data to the target
	long bufferState;
    if (0 != m_rtdxWrite->Write(sa, &bufferState))
		throw runtime_error("RTDX write failed.");

	::VariantClear(&sa); // cleanup
}

Image8bpp *RTDX::readImage()
{
	static Ipp8u *pReadBuffer = NULL;
	static int stride = -1;
	if (!pReadBuffer) // 1st time around allocate aligned buffer
		pReadBuffer = ippiMalloc_8u_C1(Y_SIZE, X_SIZE, &stride);

	for (int iRow=0; iRow<X_SIZE; ++iRow)
		if (!this->readAndCopyRow(Y_SIZE, pReadBuffer+iRow*stride))
			TRACE("read row %d failed, try again...\n", iRow--);

	return new Image8bpp(X_SIZE, Y_SIZE, stride, pReadBuffer);
}

bool RTDX::readAndCopyRow(int nPixels, Ipp8u *pDst)
{
	VARIANT sa; // pointer to a SAFEARRAY
                
	::VariantInit(&sa); // initialize VARIANT
	if (0 != m_rtdxRead->ReadSAI4(&sa)) // read pixel data
		return false;

	unsigned char *pSrc = NULL; // pointer to raw data from RTDX
	HRESULT hr = SafeArrayAccessData(sa.parray, (void **)&pSrc);
	if (FAILED(hr))
		throw _com_error(hr);

	memcpy(pDst, pSrc, nPixels); // could use ippiCopy_8u_C1R here

	// clean up before returning
	hr = SafeArrayUnaccessData(sa.parray);
	if (FAILED(hr))
		throw _com_error(hr);
	::VariantClear(&sa);

	return true;
}