#ifndef _RTDX_H_
#define _RTDX_H_

// forward declarations
class Image8bpp;

namespace Qureshi {

	class RTDX {

	public:

		RTDX();

		~RTDX();

		void sendInteger(int x);

		void sendImage(Image8bpp *pImage);

		// client is responsible for deallocating returned object!
		Image8bpp *readImage();

	private:

		// Helper method used by readImage() to copy single scan-line,
		// returns true if read operation completed
		bool readAndCopyRow(int nPixels, Ipp8u *pDst);

		RTDXINTLib::IRtdxExpPtr m_rtdxRead,  // pointers to RTDX COM interfaces
			                    m_rtdxWrite;

	};

} // namespace Qureshi

#endif