function J = edgedet(I, N)
%
% EDGEDET   multiscale edge detection using simplified a trous DWT
%    J = EDGEDET(I, N)
%
%    J: binary edge image of type LOGICAL
%    I: input image
%    N: # wavelet decompositions
%
% NOTE: this function uses A_TROUS_DWT to perform the 2D DWT on I.
%

% undecimated wavelet transform
[approx, detail] = a_trous_dwt(I, N);

% modulus of the wavelet detail coefficients
D = abs( detail(:,:,N) );

% segment the modulus coefficient matrix
J = (D > filter2(ones(3)/9, D)) .* (D > mean2(D));

% due to the 5x5 convolution kernel and the 3x3 
% smoothing operation zero out the margins
[R C] = size(J);
J(1:3, :) = 0;
J(R-2:R, :) = 0;
J(:, 1:3) = 0;
J(:, C-2:C) = 0;