function J = haar_2d_idwt_n(I, N)
%
% HAAR_2D_IDWT_N   2D Haar Inverse Discrete Wavelet Transform
%    J = HAAR_2D_DWT_N(I, N)
%
%    J: reconstructed image
%    I: input image, must be square
%    N: # wavelet decompositions
%

I = double(I);
[nrows ncols] = size(I);
if nrows ~= ncols
    error('Only support square images.');
end

num_levels = log2(nrows);
if num_levels ~= floor(num_levels)
    error('Image must have power-of-2 dimensions.');
end

if N > num_levels
    error('# of levels exceeds log2(length of image)');
end

J = I;
H = haar_basis(2^num_levels);
for kk = N:-1:1
    sz = nrows/(2^(kk-1));
    P = permutation_matrix(sz);
    J(1:sz,1:sz) = inv(P*H(1:sz,1:sz))*J(1:sz,1:sz)*inv(H(1:sz,1:sz)'*P');
end