// WaveEdgeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WaveEdge.h"
#include "WaveEdgeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;
using Qureshi::HPI;

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CWaveEdgeDlg dialog



CWaveEdgeDlg::CWaveEdgeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWaveEdgeDlg::IDD, pParent)
	, m_nTargetRows(0)
	, m_nTargetCols(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWaveEdgeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_ORIG_IMAGE, m_origImage);
	DDX_Control(pDX, IDC_PROCESSED_IMAGE, m_processedImage);
}

BEGIN_MESSAGE_MAP(CWaveEdgeDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BROWSE_BUTTON, OnClickedBrowseButton)
	ON_COMMAND(ID_FILE_LOADIMAGE, OnFileLoadImage)
	ON_COMMAND(ID_FILE_QUIT, OnFileQuit)
	ON_BN_CLICKED(IDC_PROCESS_BUTTON, OnBnClickedProcessButton)
	ON_BN_CLICKED(IDC_INIT_BUTTON, OnBnClickedInitButton)
END_MESSAGE_MAP()


// CWaveEdgeDlg message handlers

BOOL CWaveEdgeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	this->GetDlgItem(IDC_TARGET_EDIT)->SetWindowText(_T("..\\C6701EVM_HPI\\Debug\\wave_edge_detect.out"));
	this->GetDlgItem(IDC_NUM_DECOMPOSITIONS_EDIT)->SetWindowText("1");
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWaveEdgeDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWaveEdgeDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		try {

			if (m_apOrigBitmap.get())
				m_apOrigBitmap->render(m_origImage.GetSafeHwnd());

			if (m_apProcessedBitmap.get())
				m_apProcessedBitmap->render(m_processedImage.GetSafeHwnd());

			CDialog::OnPaint();

		} catch (exception &e) {

			this->MessageBox(e.what(), _T("Draw Error"), MB_OK|MB_ICONERROR);
			this->EndDialog(IDOK);

		} catch (CException *e) {

			e->ReportError(MB_OK|MB_ICONERROR);
			this->EndDialog(IDOK);

		}
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWaveEdgeDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CWaveEdgeDlg::OnClickedBrowseButton()
{
	// prompt for target .out file ...
	CFileDialog dlg(TRUE, // construct a File Load dialog
					_T(".out"),
					_T(""),
					OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT,
					_T("OUT Files (*.out)|*.out||"),
					NULL);

	if (IDOK == dlg.DoModal())
		this->GetDlgItem(IDC_TARGET_EDIT)->SetWindowText((LPCSTR)dlg.GetPathName());
}

void CWaveEdgeDlg::OnFileLoadImage()
{
	// prompt for target .out file ...
	CFileDialog dlg(TRUE, // construct a File Load dialog
					_T(".out"),
					_T(""),
					OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT,
					_T("BMP Files (*.bmp)|*.bmp||"),
					NULL);

	if (IDOK == dlg.DoModal()) {
		try {
			m_apOrigBitmap = auto_ptr<Image8bpp>(new Image8bpp(dlg.GetPathName()));
			if (m_nTargetRows && m_nTargetCols) {
				this->GetDlgItem(IDC_PROCESS_BUTTON)->EnableWindow();
				this->OnPaint();
			}
		} catch (exception &e) {
			this->MessageBox(e.what(), _T("File|Load Error"), MB_OK|MB_ICONERROR);
		}
	}
}

void CWaveEdgeDlg::OnFileQuit()
{
	if (IDYES == this->MessageBox(_T("Quit Application?"), _T("Confirm Exit"), MB_YESNO|MB_ICONQUESTION))
		this->OnOK();
}

void CWaveEdgeDlg::OnBnClickedProcessButton()
{
	if (!m_apOrigBitmap.get()) {
		this->MessageBox(_T("Please load in an image."), _T("Error"), MB_OK|MB_ICONERROR);
		return;
	}

	if (!m_nTargetRows || !m_nTargetCols) {
		this->MessageBox(_T("EVM not initialized."), _T("Error"), MB_OK|MB_ICONERROR);
		return;
	}

	if (m_apOrigBitmap.get()) {
		try {

			UINT nWaveletLevels = this->GetDlgItemInt(IDC_NUM_DECOMPOSITIONS_EDIT);
			if (nWaveletLevels < 0)
				throw runtime_error("Invalid # of wavelet decompositions");

			// send the image
			m_apHPI->sendImage(m_apOrigBitmap.get(), nWaveletLevels);

			// read back the processed image
			m_apProcessedBitmap = auto_ptr<Image8bpp>( m_apHPI->readImage() );
			m_apProcessedBitmap->binarize();

			this->OnPaint();

		} catch (exception &e) {

			this->MessageBox(e.what(), _T("HPI Error"), MB_OK|MB_ICONERROR);

		}
	}
}

void CWaveEdgeDlg::OnBnClickedInitButton()
{
	CString programFile;
	this->GetDlgItem(IDC_TARGET_EDIT)->GetWindowText(programFile);
	if (!programFile.IsEmpty()) {
		try {

			m_apHPI = auto_ptr<HPI>(new HPI((LPCSTR)programFile));
			pair<int,int> imgDims = m_apHPI->init();
			m_nTargetRows = imgDims.first;
			m_nTargetCols = imgDims.second;
			TRACE("HANDSHAKE: image size is %d x %d\n", m_nTargetRows, m_nTargetCols);
			this->GetDlgItem(IDC_PROCESS_BUTTON)->EnableWindow();

		} catch (exception &e) {

			this->MessageBox(e.what(), _T("HPI error"), MB_OK|MB_ICONERROR);

		}
	}
}
