#include <windows.h>
#include <exception>
#include <string>
#include <sstream>
#include <memory>
#include "mex.h"
#include "hpi.h"

using std::string;
using std::runtime_error;
using std::ostringstream;
using std::pair;

// this object does all of the HPI communication
Qureshi::HPI *pHPI = NULL;

//
// DLL entry point
//

extern "C" BOOL APIENTRY DllMain( HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserve)
{
    return TRUE;
}

extern "C" void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[]) 
{
  static pair<int,int> frameSize; // from HPI::init()

  try {

    // sanity check function arguments

    if (1==nrhs && mxCHAR_CLASS==mxGetClassID(prhs[0])) {
	  // initialization
      if (pHPI) delete pHPI;
      char *pathname = mxArrayToString(prhs[0]);
      if (!pathname)
        throw runtime_error("Failed to extract pathname string.");
      pHPI = new Qureshi::HPI(pathname);
	  frameSize = pHPI->init();
      return;
	}
	else if (2==nrhs) { // arg 1 = image, arg 2 = app-specific data 
      mxClassID dataTypeArg1 = mxGetClassID(prhs[0]),
		        dataTypeArg2 = mxGetClassID(prhs[1]);
      if (mxUINT8_CLASS!=dataTypeArg1 || mxUINT32_CLASS!=dataTypeArg2) 
        throw runtime_error("Expect image to be UINT8 and 2nd arg to be UINT32");
      
      if (nlhs != 1)
        throw runtime_error("One output argument required.");

      // image processing occurs below ...
    }
    else
      throw runtime_error("Invalid combination of input arguments");

    // verify size of video frame
    int nr = mxGetM(prhs[0]), nc = mxGetN(prhs[0]);
	if (frameSize.first!=nr || frameSize.second!=nc) {
      ostringstream ostr;
      ostr << "Expecting " << frameSize.first << "x" << frameSize.second
           << " frame, got " << nr << "x" << nc;
      throw runtime_error(ostr.str().c_str());
	}

    // if we got this far, send msg to DSP
    unsigned int msg2DSP = *mxGetPr(prhs[1]);
    pHPI->sendImage(prhs[0], msg2DSP);

    // allocate output (denoised) frame
    plhs[0] = mxCreateNumericMatrix(nr, nc, mxUINT8_CLASS, mxREAL);

    // and now we wait while the EVM does its thing
    pHPI->readImage(plhs[0]);

  } 
  catch (exception &e) {
    mexErrMsgTxt(e.what()); // propogate error status back to MATLAB
  }
}