function J = hist_equalize(I)
%
% HIST_EQUALIZE   histogram equalization
%    J = HIST_EQUALIZE(I)
%
%    J: equalized image
%    I: input image, may be UINT8 or UINT16
%

if strcmp('uint8', class(I))
    nlevels = 256;
elseif strcmp('uint16', class(I))
    nlevels = 65536;
else
    error('Require 8-bit or 16-bit input image');
end

% normalized histogram (discrete PDF) and from that get CDF
hgram = histc(I(:), 0:nlevels-1) ./ length(I(:));
CDF = cumsum(hgram);

max_pixel = nlevels - 1;
LUT = round(max_pixel .* CDF);

% apply LUT to input image I
% NOTE: must promote to real because certain operations
%       now allowed with integer objects and add 1 because
%       MATLAB is one-based yet pixel intensities are 0-based.
J = LUT(double(I) + 1);

% retain original type
if 256 == nlevels
    J = uint8(J);
else
    J = uint16(J);
end