#include "stdafx.h"
#include <numeric>
#include "AddNoise.h"

using namespace std;

Image8bpp *AddNoise::SpeckleNoise(const Image8bpp *pIn, float variance)
{
	if (variance<0.0 || variance>1.0)
		throw runtime_error("Noise variance must be b/w [0-1.0]");

	unsigned int N = pIn->getHeight()*pIn->getWidth(),
		         seed = (unsigned)time(NULL);

	// allocate memory to store gaussian random #'s
	Ipp32f *pRandNums = (Ipp32f *)ippsMalloc_32f(N*sizeof(Ipp32f));
	if (ippStsNoErr != ippsRandGauss_Direct_32f(pRandNums, N, 0.f, sqrt(variance), &seed))
		throw runtime_error("Failed to generate gaussian prng sequence!");

	Image8bpp *pOut = new Image8bpp(*pIn); // allocate output image

	// add multiplicative speckle noise here
	Ipp32f *pNoise = pRandNums;
	for (int iRow=0; iRow<pIn->getHeight(); ++iRow) {
		Ipp8u *pOutScanLine = pOut->getPixels() + iRow*pOut->getStride();
		for (int iCol=0; iCol<pIn->getWidth(); ++iCol, pOutScanLine++, pNoise++) {
			float corrupted = *pOutScanLine + (*pOutScanLine) * (*pNoise);
			*pOutScanLine = (corrupted>255.f) ? 255 : (Ipp8u)corrupted;
			*pOutScanLine = (corrupted<0.f) ? 0.f : (Ipp8u)corrupted;
		}		
	}
	
	ippsFree(pRandNums);
	return pOut;
}

Image8bpp *AddNoise::SaltAndPepper(const Image8bpp *pIn, float percentage)
{
	if (percentage<0.0 || percentage>1.0)
		throw runtime_error("Percentage of shot noise must be b/w [0-1.0]");

	srand((unsigned)time(NULL)); // seed generator with current time

	Image8bpp *pOut = new Image8bpp(*pIn); // allocate output image

	// those pixels less than or equal to percentage are to be corrupted
	vector<float> u(pIn->getHeight()*pIn->getWidth());
	AddNoise::UniformDist(&u);

	// corrupt some of pIn's pixels here
	vector<float>::iterator pu = u.begin();
	for (int iRow=0; iRow<pIn->getHeight(); ++iRow) {
		Ipp8u *pOutScanLine = pOut->getPixels() + iRow*pOut->getStride();
		for (int iCol=0; iCol<pIn->getWidth(); ++iCol, pOutScanLine++) 
			if (*pu++ <= percentage)
				*pOutScanLine = (AddNoise::RandN()<0.0) ? 0 : 255;
	}
	
	return pOut;
}

void AddNoise::UniformDist(vector<float> *pSamples)
{
	for (unsigned int ii=0; ii<pSamples->size(); ++ii)
		pSamples->at(ii) = (float)rand()/RAND_MAX;
}

float AddNoise::RandN()
{
	vector<float> u(12); // generate normal dist from sum of uniform dist
	AddNoise::UniformDist(&u);
	// Transform uniform dist to normal dist
	// by applying the central limit theorem.
	return accumulate(u.begin(), u.end(), 0.f) - 6;
}