#ifndef _ADD_NOISE_H_
#define _ADD_NOISE_H_

#include <vector>

// forward decls
class Image8bpp;

class AddNoise {

public:

	// Uses ipps (Intel Signal Processing Library) functions to corrupt
	// an image with speckle noise - client is responsible for deallocating
	// the returned object!
	static Image8bpp *SpeckleNoise(const Image8bpp *In, float variance);

	// Input var percentage is a number between [0-1.0] and specifies
	// how much shot noise to add.  Client is responsible for deallocating
	// the returned object!
    static Image8bpp *SaltAndPepper(const Image8bpp *pIn, float percentage);	

	// Returns in pSamples pSamples->size() uniformly distributed samples
	// on the interval (0.0, 1.0).  A port of the MATLAB function rand().
	static void UniformDist(std::vector<float> *pSamples);

	// Returns a pseudo-random number from a normal distribution,
	// with zero mean, variance one, and standard deviation one.  A port
	// of the MATLAB function randn().
	static float RandN();

};

#endif // _ADD_NOISE_H_