function J = add_speckle_noise(I, variance)
%
% ADD_SPECKLE_NOISE   corrupt an image with speckle noise
%    J = ADD_SPECKLE_NOISE(I, variance)
%
%    J: noisy image
%    I: input image, must be UINT8 or UINT16
%    variance: noise variance
%

J = double(I) + sqrt(variance).*randn(size(I)).*double(I);
if isa(I, 'uint8')
    J = uint8(J+0.5);
elseif isa(I, 'uint16')
    J = uint16(I+0.5);
end