#include "stdafx.h"
#include <numeric>
#include "AddNoise.h"

using namespace std;

Image8bpp *AddNoise::SaltAndPepper(const Image8bpp *pIn, float percentage)
{
	if (percentage<0.0 || percentage>1.0)
		throw runtime_error("Percentage of shot noise must be b/w [0-1.0]");

	srand((unsigned)time(NULL)); // seed generator with current time

	Image8bpp *pOut = new Image8bpp(*pIn); // allocate output image

	// those pixels less than or equal to percentage are to be corrupted
	vector<float> u(pIn->getHeight()*pIn->getWidth());
	AddNoise::UniformDist(&u);

	// corrupt some of pIn's pixels here
	vector<float>::iterator pu = u.begin();
	for (int iRow=0; iRow<pIn->getHeight(); ++iRow) {
		Ipp8u *pOutScanLine = pOut->getPixels() + iRow*pOut->getStride();
		for (int iCol=0; iCol<pIn->getWidth(); ++iCol, pOutScanLine++) 
			if (*pu++ <= percentage)
				*pOutScanLine = (AddNoise::RandN()<0.0) ? 0 : 255;
	}
	
	return pOut;
}

void AddNoise::UniformDist(vector<float> *pSamples)
{
	for (int ii=0; ii<pSamples->size(); ++ii)
		pSamples->at(ii) = (float)rand()/RAND_MAX;
}

float AddNoise::RandN()
{
	vector<float> u(12); // generate normal dist from sum of uniform dist
	AddNoise::UniformDist(&u);
	// Transform uniform dist to normal dist
	// by applying the central limit theorem.
	return accumulate(u.begin(), u.end(), 0.f) - 6;
}